<?php
// Fix orders table to add missing columns
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "reviewprcom_db";

try {
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    
    echo "<h2>Fixing Orders Table Columns...</h2>";
    
    // Check current table structure
    $result = $conn->query("DESCRIBE orders");
    $existing_columns = [];
    while ($row = $result->fetch_assoc()) {
        $existing_columns[] = $row['Field'];
    }
    
    echo "<p>Current columns: " . implode(', ', $existing_columns) . "</p>";
    
    // Add missing columns
    $columns_to_add = [
        'customer_name' => "ADD COLUMN customer_name VARCHAR(100) DEFAULT NULL AFTER customer_email",
        'review_location' => "ADD COLUMN review_location TEXT DEFAULT NULL",
        'reviews_per_day' => "ADD COLUMN reviews_per_day INT DEFAULT NULL",
        'customer_notes' => "ADD COLUMN customer_notes TEXT DEFAULT NULL",
        'promo_code' => "ADD COLUMN promo_code VARCHAR(50) DEFAULT NULL",
        'file_name' => "ADD COLUMN file_name VARCHAR(255) DEFAULT NULL",
        'file_link' => "ADD COLUMN file_link TEXT DEFAULT NULL"
    ];
    
    foreach ($columns_to_add as $column => $sql) {
        if (!in_array($column, $existing_columns)) {
            $full_sql = "ALTER TABLE orders " . $sql;
            if ($conn->query($full_sql)) {
                echo "<p>✅ Added column: $column</p>";
            } else {
                echo "<p>❌ Failed to add column $column: " . $conn->error . "</p>";
            }
        } else {
            echo "<p>✓ Column $column already exists</p>";
        }
    }
    
    // Show final table structure
    echo "<br><h3>Final Table Structure:</h3>";
    $result = $conn->query("DESCRIBE orders");
    echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
    echo "<tr><th>Column</th><th>Type</th><th>Null</th><th>Default</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . ($row['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<br><p>✅ Orders table structure updated successfully!</p>";
    echo "<br><a href='simple-checkout.php?service=Google%20Reviews%20Package&price=49.99' style='background: #3b82f6; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-right: 10px;'>Test Checkout</a>";
    echo "<a href='admin_dashboard.php' style='background: #10b981; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>View Admin Panel</a>";
    
    $conn->close();
    
} catch (Exception $e) {
    echo "<h2>❌ Error</h2>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>

<style>
body { 
    font-family: Arial, sans-serif; 
    max-width: 800px; 
    margin: 50px auto; 
    padding: 20px;
    background: #f8fafc;
}
h2, h3 { color: #1e293b; }
p { margin: 10px 0; }
table { width: 100%; }
th, td { padding: 8px; text-align: left; }
th { background: #e2e8f0; }
</style>
